#ifndef LG_GFX_H
#define LG_GFX_H

#define RGB16(r,g,b)  ((r)+((g)<<5)+((b)<<10))		//Converts a RGB color to 15 bit RGB

//FOR USE WITH REG_DISPCNT
#define MODE_0			0x0
#define MODE_1			BIT00
#define MODE_2			BIT01
#define MODE_3			BIT00 | BIT01
#define MODE_4			BIT02
#define MODE_5			BIT00 | BIT02

#define BACKBUFFER		BIT04

#define OBJ_MAP_2D		0x0
#define OBJ_MAP_1D		BIT06

#define BG0_ENABLE		BIT08
#define BG1_ENABLE		BIT09
#define BG2_ENABLE		BIT10
#define BG3_ENABLE		BIT11
#define BG_ALL 15<<8
#define OBJ_ENABLE		BIT12

#define CreateScreenMem(BASE)	(u16*)(0x6000000+(BASE)*0x800)

//FOR USE WITH BG-_CNT
#define BG_PRIORITY(x)			x
#define CHAR_MEM(x)				x<<2
#define SCREEN_MEM(x)			x<<8
#define BG_MOSAIC_ENABLE		BIT06
#define BG_COLOR_256			BIT07
#define BG_COLOR_16				0x0
#define TEXTBG_SIZE_256x256		0
#define TEXTBG_SIZE_512x256		BIT14
#define TEXTBG_SIZE_256x512		BIT15
#define TEXTBG_SIZE_512x512		BIT14 | BIT15
#define ROTBG_SIZE_128x128		0
#define ROTBG_SIZE_256x256		BIT14
#define ROTBG_SIZE_512x512		BIT15
#define ROTBG_SIZE_1024x1024	BIT14 | BIT15
#define WRAPAROUND				BIT13

//Tiles is written to here
#define CharMem0 ((u16*)0x6000000)
#define CharMem1 ((u16*)0x6004000)
#define CharMem2 ((u16*)0x6008000)
#define CharMem3 ((u16*)0x600C000)

//VRAM
#define VideoBuffer ((u16*)0x6000000)
//Palettes
#define BGPaletteMem ((u16*)0x5000000)
#define OBJPaletteMem ((u16*)0x5000200)

//Blending
#define MODE_NONE		0
#define	MODE_BLEND		BIT06
#define MODE_LIGHTEN	BIT07
#define MODE_DARKEN	BIT06|BIT07

#define TOP_BG0			BIT00
#define TOP_BG1			BIT01
#define TOP_BG2			BIT02
#define TOP_BG3			BIT03
#define TOP_OBJ			BIT04
#define TOP_BACKDROP	BIT05

#define BOTTOM_BG0		BIT08
#define BOTTOM_BG1		BIT09
#define BOTTOM_BG2		BIT10
#define BOTTOM_BG3		BIT11
#define BOTTOM_OBJ		BIT12
#define BOTTOM_BACKDROP	BIT13

#define Blend(a, b)		REG_COLEV = ((a)<< 8) | (b)
#define Fade(y)			REG_COLEY = (y)
#define WaitForVSync()	{ while(REG_DISPSTAT&1); while(!(REG_DISPSTAT&1)); }
//#define WaitForVSync()	SystemCall(5);

#endif
